package easik.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;

import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;


import easik.Easik;
import easik.EasikConstants;
import easik.sketch.util.Tex.TexFile;


/**
 * A class to export the current sketch as a Tex file, to be interpreted using GasTex.
 * 
 * @author Vera Ranieri 2006
 * @author Kevin Green 2006
 * @since 2006-07-10 Vera Ranieri
 * @version 2006-08-21 Kevin Green
 *
 */
public class ExportTexAction extends AbstractAction{

	/**
	 * Creates a new ExportSQLTextAction.  Adds a new menu option to the File menu.
	 */
	public ExportTexAction(){
		super("Export to Tex File");
		putValue(AbstractAction.MNEMONIC_KEY, new Integer(KeyEvent.VK_X));
		putValue(AbstractAction.SHORT_DESCRIPTION, "Create a TeX file to be implemented using GasTex");
		
	}

	/**
	 * Creates a new SQL text file based on the current sketch.  Displays a message if an error occurred.
	 * 
	 * @param e The action event
	 * @since 2006-07-10 Vera Ranieri
	 */
	public void actionPerformed(ActionEvent e) {
		if(Easik.getInstance().getFrame().getSketch().containsMultiEdges()){
			JOptionPane.showMessageDialog(null, "The sketch contains multiple edges between entities.\nThis feature is not supported by the export feature.\nPlease remove the extra edges and try again",
					"Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		if(!Easik.getInstance().getFrame().getSketch().getEntities().isEmpty()){
				JFileChooser saveDialog = new JFileChooser(Easik.getInstance().getIni().getDefaultFolder());
				saveDialog.addChoosableFileFilter( new TexFileFilter() );
				saveDialog.showSaveDialog(Easik.getInstance().getFrame());
				File selFile = saveDialog.getSelectedFile();
				
				if (selFile != null) {
					if(!selFile.getName().endsWith(EasikConstants.TEX_FILE)){
						selFile = new File(selFile.getPath()+EasikConstants.TEX_FILE);
					}
					TexFile file = new TexFile(selFile);
					try{
						file.save(Easik.getInstance().getFrame().getSketch());
						JOptionPane.showMessageDialog(null, "TeX file successfully created!", "Success",
								JOptionPane.INFORMATION_MESSAGE);
					}
					catch(Exception x){
						System.out.println(x.toString());
						x.printStackTrace();
						JOptionPane.showMessageDialog(null, "Error Creating the TeX file.\n"
								+"File not successfully created.", "Error", JOptionPane.ERROR_MESSAGE);
					}
				}
				
			}
		else{
			JOptionPane.showMessageDialog(null, "Sketch cannot be empty", "Error", JOptionPane.ERROR_MESSAGE);
		}
		
	}
}
